/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWHasWSParameterDefs;
import filenet.vw.api.VWActionType;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public class VWReplyInstruction
extends VWInstructionDefinition
implements Serializable,
IVWHasWSParameterDefs {
    private static final long serialVersionUID = 7480L;
    private String m_PartnerLinkName = null;
    private String m_OperationName = null;
    private String m_FaultName = null;
    private String m_MessageExpr = null;
    private String m_MessageFromSchemaName = null;
    private String m_MessageFromElementName = null;
    private VWWebServiceParameterDefinition[] m_Parameters = null;
    private VWArrayHandler m_ParametersHandler = new VWArrayHandler();
    private String m_CorrelationSetName = null;
    private String[][] m_CorrelationSetProperties = null;
    private boolean m_HasAttachments = false;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-10-01 17:28:10 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/8 $";
    }

    protected VWReplyInstruction(VWCompoundStepDefinition CompStep, int theInstructionId) throws VWException {
        super(CompStep, theInstructionId, 41);
    }

    protected VWReplyInstruction(VWCompoundStepDefinition CompStep, int theInstructionId, String thePartnerLinkName, String theOperationName) throws VWException {
        super(CompStep, theInstructionId, 41);
        this.setPartnerLinkName(thePartnerLinkName);
        this.setOperationName(theOperationName);
    }

    public void setFaultName(String theName) throws VWException {
        this.m_FaultName = theName;
    }

    public String getFaultName() throws VWException {
        return this.m_FaultName;
    }

    public String getMessageExpr() {
        return this.m_MessageExpr;
    }

    public void setMessageExpr(String theMessageExpr) throws VWException {
        this.m_MessageExpr = theMessageExpr;
    }

    public void setPartnerLinkName(String thePartnerLinkName) throws VWException {
        if (thePartnerLinkName != null && thePartnerLinkName.length() > 0) {
            if (this.getStep().getMap() != null) {
                if (this.m_PartnerLinkName != null && this.m_PartnerLinkName.length() > 0 && this.getStep().getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName)) {
                    this.getStep().getMap().getWorkflow().getPartnerLink(this.m_PartnerLinkName).removeReplyStepRef(this);
                }
                if (this.getStep().getMap().getWorkflow().isExistingPartnerLinkName(thePartnerLinkName)) {
                    this.getStep().getMap().getWorkflow().getPartnerLink(thePartnerLinkName).addReplyStepRef(this);
                }
            }
        } else if (this.m_PartnerLinkName != null && this.m_PartnerLinkName.length() > 0 && this.getStep().getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName)) {
            this.getStep().getMap().getWorkflow().getPartnerLink(this.m_PartnerLinkName).removeReplyStepRef(this);
        }
        this.m_PartnerLinkName = thePartnerLinkName;
    }

    public String getPartnerLinkName() {
        return this.m_PartnerLinkName;
    }

    public void setOperationName(String theOperationName) throws VWException {
        this.m_OperationName = theOperationName;
    }

    public String getOperationName() {
        return this.m_OperationName;
    }

    public VWWebServiceParameterDefinition createParameter(String theName, String theValue, int theType, boolean theIsArray) throws VWException {
        VWWebServiceParameterDefinition newParameter = new VWWebServiceParameterDefinition(this, theName, 1, theType, theIsArray, theValue);
        this.m_Parameters = (VWWebServiceParameterDefinition[])this.m_ParametersHandler.addElementToArray(this.m_Parameters, newParameter);
        return newParameter;
    }

    public void deleteParameter(int theSequenceNumber) throws VWException {
        int index = this.m_ParametersHandler.getIndexFromIntFieldValue(this.m_Parameters, "m_Sequence", theSequenceNumber);
        if (index == -1) {
            throw new VWException("vw.api.VWReplyInstructionParameterNotFound", "No parameter found with sequence number equal to {0} in reply instruction.", String.valueOf(theSequenceNumber));
        }
        this.m_ParametersHandler.deleteElementFromArray(this.m_Parameters, index);
    }

    public void deleteAllParameters() throws VWException {
        this.m_ParametersHandler = new VWArrayHandler();
        this.m_Parameters = null;
    }

    public VWWebServiceParameterDefinition getParameterDefinition(int theSequenceNumber) throws VWException {
        int index = this.m_ParametersHandler.getIndexFromIntFieldValue(this.m_Parameters, "m_Sequence", theSequenceNumber);
        if (index == -1) {
            throw new VWException("vw.api.VWReplyInstructionParameterNotFound", "No parameter found with sequence number equal to {0} in reply instruction.", String.valueOf(theSequenceNumber));
        }
        return this.m_Parameters[index];
    }

    public VWWebServiceParameterDefinition[] getParameterDefinitions() throws VWException {
        return (VWWebServiceParameterDefinition[])this.m_ParametersHandler.getElements(this.m_Parameters);
    }

    public String toString() {
        String retVal = "";
        try {
            retVal = VWActionType.typeToString(this.action);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public void setHasAttachments(boolean theHasAttachmentsFlag) throws VWException {
        this.m_HasAttachments = theHasAttachmentsFlag;
    }

    public boolean getHasAttachments() {
        return this.m_HasAttachments;
    }

    public void validate(VWSession theSession, Vector EDefVector, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext, myStep);
    }

    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep) throws VWException {
        block26: {
            VWWebServiceParameterDefinition[] p;
            VWValidationError theError;
            VWString theMessage;
            VWWorkflowSignature myWflSignature = this.getStep().getMap().getWorkflow().getWorkflowSignature(validationContext);
            VWWorkflowSignature myBaseWflSignature = this.getStep().getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
            if (this.m_PartnerLinkName == null || !myStep.getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName) && (myBaseWflSignature == null || !myBaseWflSignature.isPartnerlinkName(this.m_PartnerLinkName))) {
                theMessage = new VWString("vw.api.VWReplyInstructionBadPartnerLinkName", "Partner link name, {0}, is not the name of a partner link in this workflow definition.", this.m_PartnerLinkName);
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
            }
            if (this.m_OperationName == null || this.m_OperationName == "") {
                theMessage = new VWString("vw.api.VWReplyInstructionBadOperationName", "Operation name is null or empty");
                theError = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError);
            }
            if (this.m_MessageExpr != null) {
                VWCompiledExpr compRes = new VWCompiledExpr();
                String[] theErrorStrings = VWExpr.compileVWExpr(this.m_MessageExpr, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int i = 0; i < errorCount; ++i) {
                        VWString theMessage2 = new VWString("vw.api.VWReplyInstructionSyntaxErrorInMessageExpr", "Syntax error in message expression of reply instruction (expected string expression) : {0}", theErrorStrings[i]);
                        VWValidationError theError2 = new VWValidationError(7, 1, myStep.getName(), this.m_MessageExpr, theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError2);
                    }
                } else if (compRes.getResultIsArray() || compRes.getResultType() != 2 && compRes.getResultType() != 128) {
                    VWString theMessage3 = new VWString("vw.api.VWReplyInstructionMessageNotString", "Message expression parameter must be an string expression, found a {0}.", VWFieldType.typeToString(compRes.getResultType()) + (compRes.getResultIsArray() ? "[ ]" : ""));
                    VWValidationError theError3 = new VWValidationError(7, 1, myStep.getName(), this.m_MessageExpr, theMessage3.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError3);
                }
            }
            if ((p = this.getParameterDefinitions()) != null) {
                for (int i = 0; i < p.length; ++i) {
                    p[i].validate(validationContext, myStep);
                    if (VWFieldType.isValidWebServiceParamName(p[i].getName())) continue;
                    VWString theMessage4 = new VWString("vw.api.VWReplyInstructionParamInValidWebServiceParamName", "Reply instruction parameter named \"{0}\" contains space(s) or colon(s).", p[i].getName());
                    VWValidationError theError4 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage4.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError4);
                }
            }
            if (p != null) {
                VWValidationError theError5;
                int i;
                boolean[] seqNumFound = new boolean[p.length];
                for (i = 0; i < p.length; ++i) {
                    if (p[i].getSequenceNumber() < 0 || p[i].getSequenceNumber() >= p.length) {
                        VWString theMessage5 = new VWString("vw.api.VWReplyInstructionParamSeqNumberOutOfRange", "Reply instruction parameter named {0} has sequence number {1}, which outside the range 0-{2}.", p[i].getName(), String.valueOf(p[i].getSequenceNumber()), String.valueOf(p.length));
                        theError5 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage5.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError5);
                        continue;
                    }
                    if (seqNumFound[p[i].getSequenceNumber()]) {
                        VWString theMessage6 = new VWString("vw.api.VWReplyInstructionDuplicateSeqNumber", "Reply instruction parameter named {0} has sequence number {1}, which is already in use by parameter named {2} in this reply instruction.", p[i].getName(), String.valueOf(p[i].getSequenceNumber()), this.getParameterDefinition(i).getName());
                        theError5 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage6.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError5);
                        continue;
                    }
                    seqNumFound[p[i].getSequenceNumber()] = true;
                }
                for (i = 0; i < p.length; ++i) {
                    seqNumFound[i] = false;
                    if (!false) continue;
                    VWString theMessage7 = new VWString("vw.api.VWReplyInstructionParamGapInSeqNumber", "Reply instruction sequence number {0}, should occur in the parameters of this reply instruction but no parameter was found with that sequence number.", String.valueOf(i));
                    theError5 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage7.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError5);
                }
            }
            if (p != null && p.length != 0) {
                if (p[0].getLexicalLevel() != 0 && p[0].getLexicalLevel() != 1) {
                    VWWebServiceParameterDefinition pDef = null;
                    try {
                        pDef = this.getParameterDefinition(0);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    VWString theMessage8 = new VWString("vw.api.VWReplyInstructionParamSeqNumberZeroArrayNotLexLvlZero", "Reply instruction parameter named, {0}, with sequence number 0, must have lexical level 0 or 1, found lexical level {1}.", pDef != null ? pDef.getName() : "<< name not found - probably missing parameter with sequence number 0 >>", pDef != null ? String.valueOf(pDef.getLexicalLevel()) : "unknown");
                    VWValidationError theError6 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage8.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError6);
                } else {
                    for (int i = 1; i < p.length; ++i) {
                        if (p[i].getLexicalLevel() >= 0 && p[i].getLexicalLevel() <= this.getParameterDefinition(p[i].getSequenceNumber() - 1).getLexicalLevel() + 1) continue;
                        VWString theMessage9 = new VWString("vw.api.VWReplyInstructionParamLexLvlInconsistency", "Reply instruction parameter named, {0}, has lexical level {1}, expected lexical level in the range 0 - {2}.", this.getParameterDefinition(i).getName() + " (seq. # " + String.valueOf(this.getParameterDefinition(i).getSequenceNumber()) + ") ", String.valueOf(this.getParameterDefinition(i).getLexicalLevel()), String.valueOf(this.getParameterDefinition(p[i].getSequenceNumber() - 1).getLexicalLevel() + 1));
                        VWValidationError theError7 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage9.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                        validationContext.addValidationError(theError7);
                    }
                }
            }
            if (p != null && p.length > 0 && this.m_MessageExpr != null) {
                VWString theMessage10 = new VWString("vw.api.VWReplyInstructionInvalidParameterCombination", "Reply instruction contains both parameters and a message.");
                VWValidationError theError8 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage10.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError8);
            }
            if (p == null && this.m_MessageExpr == null && this.m_FaultName == null) {
                VWString theMessage11 = new VWString("vw.api.VWReplyInstructionNoMessageNoParamsNoFault", "Reply instruction contains neither parameters not an XML message, and it does not specify a Fault.");
                VWValidationError theError9 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage11.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError9);
            }
            if (p != null && p.length > 0 && this.m_FaultName != null) {
                VWString theMessage12 = new VWString("vw.api.VWReplyInstructionInvalidParameterFaultCombination", "Reply instruction contains parameters, but it also specifies a fault, can do one of the other, but not both.");
                VWValidationError theError10 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage12.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                validationContext.addValidationError(theError10);
            }
            if (this.m_MessageFromSchemaName != null) {
                try {
                    myStep.getMap().getWorkflow().getSchema(this.m_MessageFromSchemaName);
                }
                catch (VWException e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isSchemaName(this.m_MessageFromSchemaName)) break block26;
                    VWString theMessage13 = new VWString("vw.api.VWReplyInstructionBadSchema", "Reply instruction has a schema name, {0}, which is not the name of a schema defined in this workflow definition.", this.m_MessageFromSchemaName);
                    VWValidationError theError11 = new VWValidationError(7, 1, myStep.getName(), VWActionType.typeToString(this.action), theMessage13.toString(), myStep.getMap().getName(), myStep.getStepId(), this.instructionId);
                    validationContext.addValidationError(theError11);
                }
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        int i;
        String ATTRIB_INDENT = "\t\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWReplyInstructionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t\t<reply\n");
        theBuffer.append(ATTRIB_INDENT + "Id=\"" + Integer.toString(this.getInstructionId()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Action=\"" + VWActionType.typeToString(this.getAction()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "partnerLink=\"" + VWXMLHandler.toXMLString(this.m_PartnerLinkName) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "operation=\"" + VWXMLHandler.toXMLString(this.m_OperationName) + "\"\n");
        if (this.m_FaultName != null) {
            theBuffer.append(ATTRIB_INDENT + "faultName=\"" + VWXMLHandler.toXMLString(this.m_FaultName) + "\"\n");
        }
        if (this.m_HasAttachments) {
            theBuffer.append(ATTRIB_INDENT + "hasAttachments=\"true\"\n");
        }
        if (this.m_MessageExpr != null) {
            theBuffer.append(ATTRIB_INDENT + "message=\"" + VWXMLHandler.toXMLString(this.m_MessageExpr) + "\"\n");
        }
        if (this.m_MessageFromSchemaName != null) {
            theBuffer.append(ATTRIB_INDENT + "messageFromSchema=\"" + VWXMLHandler.toXMLString(this.m_MessageFromSchemaName) + "\"\n");
        }
        if (this.m_MessageFromElementName != null) {
            theBuffer.append(ATTRIB_INDENT + "messageFromElement=\"" + VWXMLHandler.toXMLString(this.m_MessageFromElementName) + "\"\n");
        }
        theBuffer.append(">\n");
        VWWebServiceParameterDefinition[] p = this.getParameterDefinitions();
        if (p != null) {
            for (i = 0; i < p.length; ++i) {
                p[i].toXML(theBuffer);
            }
        }
        if (this.m_CorrelationSetName != null) {
            theBuffer.append(ATTRIB_INDENT + "<correlationSet\n");
            ATTRIB_INDENT = ATTRIB_INDENT + "\t";
            theBuffer.append(ATTRIB_INDENT + "name=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetName) + "\">\n");
            if (this.m_CorrelationSetProperties != null) {
                for (i = 0; i < this.m_CorrelationSetProperties.length; ++i) {
                    theBuffer.append(ATTRIB_INDENT + "<property name=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetProperties[i][0]) + "\" query=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetProperties[i][1]) + "\" />\n");
                }
            }
            ATTRIB_INDENT = "\t\t\t\t";
            theBuffer.append(ATTRIB_INDENT + "</correlationSet>\n");
        }
        theBuffer.append("\t\t\t</reply>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        int i;
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        String indentD = VWXMLHandler.incXMLIndent(indentC);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWReplyInstructionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<TaskSend Implementation=\"WebService\">\n");
        VWWebServiceParameterDefinition[] parameters = this.getParameterDefinitions();
        if (parameters != null || this.m_MessageExpr != null || this.m_MessageFromSchemaName != null || this.m_MessageFromElementName != null) {
            theBuffer.append(indentB + "<Message Id=\"Outgoing\">\n");
            theBuffer.append(indentC + "<ActualParameters>\n");
            if (parameters != null) {
                for (i = 0; i < parameters.length; ++i) {
                    parameters[i].toXPDL(indentD, theBuffer);
                }
            } else {
                if (this.m_MessageExpr != null) {
                    theBuffer.append(indentD + "<fn:ActualParameter fn:Source=\"Expression\">" + VWXMLHandler.toXMLString(this.m_MessageExpr) + "</fn:ActualParameter>\n");
                }
                if (this.m_MessageFromSchemaName != null) {
                    theBuffer.append(indentD + "<fn:ActualParameter fn:Source=\"Schema\">" + VWXMLHandler.toXMLString(this.m_MessageFromSchemaName) + "</fn:ActualParameter>\n");
                }
                if (this.m_MessageFromElementName != null) {
                    theBuffer.append(indentD + "<fn:ActualParameter fn:Source=\"Element\">" + VWXMLHandler.toXMLString(this.m_MessageFromElementName) + "</fn:ActualParameter>\n");
                }
            }
            theBuffer.append(indentC + "</ActualParameters>\n");
            theBuffer.append(indentB + "</Message>\n");
        } else {
            theBuffer.append(indentB + "<Message Id=\"Outgoing\"/>\n");
        }
        theBuffer.append(indentB + "<WebServiceOperation OperationName=\"" + VWXMLHandler.toXMLString(this.m_OperationName) + "\">\n");
        theBuffer.append(indentC + "<Partner PartnerLinkId=\"" + VWXMLHandler.toXMLString(this.m_PartnerLinkName) + "\" RoleType=\"MyRole\"/>\n");
        theBuffer.append(indentB + "</WebServiceOperation>\n");
        theBuffer.append(indentB + "<fn:ReplyParameters Id=\"" + Integer.toString(this.getInstructionId()) + "\"");
        if (this.m_FaultName != null) {
            theBuffer.append("\n" + indentC + "FaultName=\"" + VWXMLHandler.toXMLString(this.m_FaultName) + "\"");
        }
        if (this.m_HasAttachments) {
            theBuffer.append("\n" + indentC + "hasAttachments=\"true\"");
        }
        theBuffer.append(">\n");
        if (this.m_CorrelationSetName != null) {
            theBuffer.append(indentB + "<correlationSet name=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetName) + "\">\n");
            if (this.m_CorrelationSetProperties != null) {
                for (i = 0; i < this.m_CorrelationSetProperties.length; ++i) {
                    theBuffer.append(indentD + "<property name=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetProperties[i][0]) + "\"\n" + VWXMLHandler.incXMLIndent(indentD) + "query=\"" + VWXMLHandler.toXMLString(this.m_CorrelationSetProperties[i][1]) + "\"/>\n");
                }
            }
            theBuffer.append(indentC + "</correlationSet>\n");
        }
        theBuffer.append(indentB + "</fn:ReplyParameters>\n");
        theBuffer.append(indentA + "</TaskSend>\n");
    }

    public void setMessageFromSchemaName(String theSchemaName) throws VWException {
        this.m_MessageFromSchemaName = theSchemaName;
    }

    public String getMessageFromSchemaName() {
        return this.m_MessageFromSchemaName;
    }

    public void setMessageFromElementName(String theElement) throws VWException {
        this.m_MessageFromElementName = theElement;
    }

    public String getMessageFromElementName() {
        return this.m_MessageFromElementName;
    }

    public void setCorrelationSetName(String theName) throws VWException {
        int nMaxNameLength = 123;
        if (theName != null && theName.length() > nMaxNameLength) {
            throw new VWException("vw.api.VWReplyInstructionCorrelationSetNameInvalidNameIsTooLong", "theName is invalid because it contains more than {0} characters.", nMaxNameLength);
        }
        if (theName != null) {
            for (int i = 1; i < theName.length(); ++i) {
                char c = theName.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '_') continue;
                throw new VWException("vw.api.VWReplyInstructionCorrelationSetNameInvalidNameBadCharacter", "Setting correlation set name, theName is invalid because it contains an invalid character \"{0}\", the name can only contain letters, digits and underscore characters.", String.valueOf(c));
            }
        }
        this.m_CorrelationSetName = theName;
    }

    public String getCorrelationSetName() {
        return this.m_CorrelationSetName;
    }

    public void setCorrelationSetProperties(String[][] theProps) throws VWException {
        if (theProps != null) {
            for (int i = 0; i < theProps.length; ++i) {
                if (theProps[i].length != 2) {
                    throw new VWException("vw.api.VWCorrelationSetPropertyArrayWrongDimension", "Correlation set property array wrong dimension, row {0} has {1} elements, should have 2 (representing the property name and property query of the correlation set property)", String.valueOf(i), String.valueOf(theProps[i].length));
                }
                if (theProps[i][0] != null && theProps[i][1] != null) continue;
                throw new VWException("vw.api.VWCorrelationSetPropertyArrayNullElement", "Correlation set property array contains a null entry in row {0}", String.valueOf(i));
            }
        }
        this.m_CorrelationSetProperties = theProps;
    }

    public String[][] getCorrelationSetProperties() {
        return this.m_CorrelationSetProperties;
    }

    protected void addMeToMyPartnerLinkReferences() throws VWException {
        if (this.getStep().getMap() != null && this.m_PartnerLinkName != null && this.m_PartnerLinkName.length() > 0 && this.getStep().getMap().getWorkflow().isExistingPartnerLinkName(this.m_PartnerLinkName)) {
            this.getStep().getMap().getWorkflow().getPartnerLink(this.m_PartnerLinkName).addReplyStepRef(this);
        }
    }
}

